;/*************************************************
; Program		:Generate PWM 
; Description	:Timer/Counter2 generates pulse at PWM3 port  
; CPU Control	:ATmega163
; File name		:PWM3.asm
; Assembler		:AVR Studio 4.05
; 
;**************************************************
.include "m163def.inc"			

			.org   	$000 
    		rjmp  reset				;Reset Handle
;/************************
; Define Register
;/************************
.def		temp		= r19
;/*******************
; Main Program
;/*******************
reset:      ldi	temp,low(RAMEND)
            out	SPL,temp          	;init Stack Pointer     
            ldi	temp,high(RAMEND)
            out	SPH,temp        	

;/*************************************************
; Use Timer/Counter1 generate PWM at the PWM1 port
;/*************************************************
PWM2M:		ldi	temp,(1<<PWM2)|(1<<COM21)|(1<<CS21)
			out	TCCR2,temp			;8 bit PWM2 non-inverted (Fck/510)
			ldi	temp,0xC0			;duty cycle = 75% and frequency = 1960 Hz
									;1 bit = 0.39 Hz
			out 	OCR2,temp		;Set compare value/duty cycle ratio
			ldi	temp,0x80
			out 	DDRD,temp
Loop_PWM2:	rjmp	Loop_PWM2	
